# MeZAVAG - a JSON Jointer.

a program to Join of two JSON files,
by a given join rules.

Input (MJSON,FJSON,Tikonim)  => Output (CJSON,LogOfChanges)
* MJSON – Male (1st ) JSON File.
* FJSON – Female (2nd ) JSON File.
* Tikonim – a JSON file of adjustments for joining the M&F JSON Files in order to deliver a CJSON.
* CJSON – Child JSON, the final JSON that will be born from the Join and Tikonim.
  
# method defintions:
JointMethod (MonF, FonM, Avg) 
key-value - “Tikonim.JointMethod” : “MonF” 
// this means that values on the same keys (under same tree path) will be taken from MJSON file, even if FJSON had a previous value in his key value pair.

JointWay (Create,Add,Replace,Remove) 
key-value - “Tikonim.JointWay” : “Create” 
//how to behave when encounter a new key-value (result from a join of JSONs) 

JointWeightsCalc (Highest,Lowest,Avrage,Random) 
key-value - “Tikonim.JointWeightsCalc” :  “Highest” 
// how to summerize the 2 JSON values for the new Child Value.

JointWeights (JSON,Tikonim) => return JSON 
//identical in key structure as input JSON. values are of % numbers per key:value (like a “mask” of weights) to be used while doing the join of JSONs

note:
When Doing Join of JSONs (by default 1st JSON = MJSON, 2nd JSON =FJSON), please Check If JSON are from same Object or Parent Object … (quality assurance)

# Join Parameters
JointMethod (MonF, FonM, Avg) 
IF JointMethos = “MonF” 
	1JSON = MJSON
	2JSON = FJSON

IF JointMethos = “FonM” 
	2JSON = MJSON
	1JSON = FJSON

IF JointMethos = “AVG” 
	// TBD
  
JointWay (Create,Add,Replace,Remove)
IF JointWay = “Create” 
//	IN CJSON:
	CJSON      replace key :: value = 1JSON (same key) :: value.
	Whenever 2JSON has a key value entrance that is not exist in 1JSON, add it to  CJSON.
	Whenever 1JSON has a key value entrance that is not exist, create it in CJSON.
IF JointWay = “Add” 
//	IN CJSON:
	CJSON 	key :: value = don’t change.
	Whenever 2JSON has a key value entrance that is not exist in 1JSON, add it to  CJSON.
	Whenever 1JSON has a key value entrance that is not exist, create it in CJSON.
	
IF JointWay = “Replace” 
//	IN CJSON:
	CJSON     replace key :: value = 1JSON (same key) :: value.
	Whenever 2JSON has a key value entrance that is not exist in 1JSON, do nothing.
	Whenever 1JSON has a key value entrance that is not exist, do nothing.
	
IF JointWay = “Remove” 
//	IN CJSON:
	CJSON     = 1JSON.   CJSON delete key :: value = 2JSON (same key).
	Whenever 2JSON has a key value entrance that is not exist in 1JSON, do nothing.
	Whenever 1JSON has a key value entrance that is not exist, do nothing.


# function explain
JointWeightsCalc (Highest,Lowest,Avrage,Random)
IF JointWeightsCalc = “Highest” 
//	IN CJSON:
	key :: value = max(1JSON.key-value, 2JSON.key-value)

IF JointWeightsCalc = “Lowest” 
//	IN CJSON:
	key :: value = min(1JSON.key-value, 2JSON.key-value)

IF JointWeightsCalc = “Avrage” 
//	IN CJSON:
	key :: value = avg(1JSON.key-value, 2JSON.key-value)

IF JointWeightsCalc = “Random” 
//	IN CJSON:
	key :: value = random()


# JSON Work Sample

Tikonim JSON

{
    "Object_ID": "11234", 				// the CJSON Object_ID
    “JointMethod” : “FonM”,
    "JointWay” : “Create”
 }

MJSON ("SimpleButton")
{
    "Object_ID": "3657858584",
    "ObjectName": "SimpleButton",
    "Object_Parent": "Object",
     "Object_Media": {
      "idle": "\"tinyurl.com/SimpleButtonidleMedia\",",
      "press": "\"tinyurl.com/SimpleButtonidleMedia\","
    },
    "Object_Optional_Values":  {
	“1” : “Israel”,
	“2” : “NewYork”,
	“3” : “Manchester”,
	“4” : “Monsi”
  }
    "Object_index_Value": "02"
}

FJSON ("SimpleButton")

{
    "Object_ID": "3657858221",
    "ObjectName": "SimpleButton",
    "Object_Parent": "Object",
     "Object_Media": {
      "idle": "\"tinyurl.com/RedSimpleButtonidleMedia\",",
      "press": "\"tinyurl.com/RedSimpleButtonidleMedia\","
    },
    "Object_Optional_Values":  {
	“1” : “Israel”,
	“2” : “NewYork”,
	“3” : “Manchester”,
	“4” : “Monsi”,
	“5” : “Miami”
  }
    "Object_index_Value": "04"
}

CJSON will look like this:

 {
    "Object_ID": "2234555",			// from Tikonim
    "ObjectName": "SimpleButton",
    "Object_Parent": "Object",
     "Object_Media": {
      "idle": "\"tinyurl.com/SimpleButtonidleMedia\",",
      "press": "\"tinyurl.com/SimpleButtonidleMedia\","
    },
    "Object_Optional_Values":  {
	“1” : “Israel”,
	“2” : “NewYork”,
	“3” : “Manchester”,
	“4” : “Monsi”,
	“5” : “Miami” 		// this comes from FJSON
  },
    "Object_index_Value": "02"
}



# JSON Merge Utility

This Python script allows you to merge JSON data from two files based on specified rules and options.

## Requirements

- Python 3.x

## Usage

1. Ensure you have Python 3.x installed on your system.

2. Place the JSON files that you want to merge (`mjson.json`, `fjson.json`) in the same directory as the script.

3. Create a JSON configuration file named `tikonim.json` with the following structure:

   ```json
   {
     "JointMethod": "MonF",
     "JointWay": "Create",
     "JointWeightsCalc": "Highest",
     "Object_ID": "optional_object_id"
   }
   ```

   - `JointMethod`: Specify the merging method. Valid values are "MonF" (merge mjson into fjson) or "FonM" (merge fjson into mjson).

   - `JointWay`: Specify the merging behavior. Valid values are "Add" (add missing keys) or "Replace" (replace existing keys).

   - `JointWeightsCalc`: Specify the calculation method for numeric values. Valid values are "Highest" (select the highest value), "Lowest" (select the lowest value), "Average" (calculate the average), or "Random" (select a random value).

   - `Object_ID` (optional): Specify an object ID to include in the merged JSON data.

4. Open a terminal or command prompt and navigate to the directory containing the script and JSON files.

5. Run the following command to execute the script and merge the JSON data:

   ```bash
   python script.py
   ```

6. The merged JSON data will be displayed in the console.

## Example

Suppose you have two JSON files, `mjson.json` and `fjson.json`, that you want to merge. Here's an example of how to configure the `tikonim.json` file:

```json
{
  "JointMethod": "MonF",
  "JointWay": "Create",
  "JointWeightsCalc": "Highest",
  "Object_ID": "12345"
}
```

- `JointMethod` is set to "MonF", indicating that `mjson.json` will be merged into `fjson.json`.

- `JointWay` is set to "Create", meaning that missing keys in `fjson.json` will be added.

- `JointWeightsCalc` is set to "Highest", which will select the highest value for numeric keys.

- `Object_ID` is set to "12345", and this value will be included in the merged JSON data.

After configuring the `tikonim.json` file, run the script as described in Step 5. The merged JSON data will be displayed in the console.

## Notes

- Make sure the specified JSON files (`mjson.json`, `fjson.json`, `tikonim.json`) exist in the same directory as the script.

- The code assumes that the JSON files are well-formed and contain valid JSON data.

- If the parent object in `mjson.json` and `fjson.json` is not the same, the script will raise a `ValueError`.

- Modify the code if additional or custom merging logic is required.

- This script uses Python's built-in `json` module for JSON handling.

- For more information on JSON formatting and the available options, refer to the Python [json](https://docs.python.org/3/library/json.html) documentation.


