import json

def join_json(mjson, fjson, tikonim):
    
    with open(mjson) as f:
        mdata = json.load(f)
    with open(fjson) as f:
        fdata = json.load(f)
    with open(tikonim) as f:
        tdata = json.load(f)
    
    
    joint_method = tdata.get("JointMethod", "MonF")
    joint_way = tdata.get("JointWay", "Create")
    joint_weights_calc = tdata.get("JointWeightsCalc", "Highest")
    
    
    m_parent = mdata.get("Object_Parent", "")
    f_parent = fdata.get("Object_Parent", "")
    if m_parent != f_parent:
        raise ValueError("JSON files are not from the same object or parent object.")
    
    
    cjson = {}

    
    if joint_method == "MonF":
        json1, json2 = mdata, fdata
    elif joint_method == "FonM":
        json1, json2 = fdata, mdata
    else:
        raise ValueError("Invalid JointMethod specified in Tikonim.")
    

    object_id = tdata.get("Object_ID")
    if object_id:
        cjson["Object_ID"] = object_id
    
    
    for key, value in json1.items():
        
        if key == 'Object_ID':
            continue
        if key not in json2 and joint_way == "Add":
            cjson[key] = value
        elif key in json2 and joint_way == "Replace":
            cjson[key] = value
        
        
        if key in json2:
            if isinstance(value, (int, float)) and isinstance(json2[key], (int, float)):
                if joint_weights_calc == "Highest":
                    cjson[key] = max(value, json2[key])
                elif joint_weights_calc == "Lowest":
                    cjson[key] = min(value, json2[key])
                elif joint_weights_calc == "Average":
                    cjson[key] = (value + json2[key]) / 2
                elif joint_weights_calc == "Random":
                    import random
                    cjson[key] = random.choice([value, json2[key]])
            else:
                cjson[key] = value
    
    
    if joint_way == "Create":
        for key, value in json2.items():
            if key not in json1:
                cjson[key] = value
    
    return cjson


mjson_file = "mjson.json"
fjson_file = "fjson.json"
tikonim_file = "tikonim.json"

result = join_json(mjson_file, fjson_file, tikonim_file)


print(json.dumps(result, indent=2))
