import sys
import json
import pymysql
import argparse

def get_args():    
    parser = argparse.ArgumentParser()
    parser.add_argument('-dbIp', type=str, default='192.168.3.4', help='The IP location of the DB')
    parser.add_argument('-dbName', type=str, default='hinb_mydb', help='The name of the DB')
    parser.add_argument('-dbUser', type=str, default='hinb_user', help='User assigned to the DB')
    parser.add_argument('-dbPass', type=str, default='0987654321!!', help='Password of the user')
    parser.add_argument('-TableName', type=str, help='Table from which to retrieve data')
    parser.add_argument('-keyValue', nargs='+', help='List of field-value pairs for the query')
    parser.add_argument('-requrseQry', type=bool, default=False, help='Whether to rerun the query using the result')
    
    return parser.parse_args()

def sql2json(args):
    # Connect to the database
    db = pymysql.connect(host=args.dbIp, user=args.dbUser, password=args.dbPass, db=args.dbName)
    cursor = db.cursor()

    # Build the SQL query
    conditions = " AND ".join([f'{k} = "{v}"' if isinstance(v, str) else f'{k} = {v}' for k, v in [_.split(",") for _ in args.keyValue]])

    sqlQuery = f'SELECT * FROM {args.TableName} WHERE {conditions}'

    # Execute the query
    cursor.execute(sqlQuery)

    # Fetch the results
    columns = [column[0] for column in cursor.description]
    rows = cursor.fetchall()
    result = []
    for row in rows:
        result.append(dict(zip(columns, row)))

    # Close the database connection
    db.close()

    # Print the JSON result
    with open('out.json', 'w+') as f:
        f.write(json.dumps(result))

def main():
    args = get_args()
    sql2json(args)

if __name__=="__main__":
    main()
    sys.exit(1)
